import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

class Benchmark {
  HashMap<Integer, Integer> hashtable;
  TreeMap<Integer, Integer> tree;
  
  // Messe die Laufzeit für eine Map
  static void benchmark(Map<Integer, Integer> map) {
    // Variiere die Anzahl der Elemente von 1, 2, 4, 8, 16, ..., 1048576
    for (int inserts = 1; inserts <= 1048576; inserts *= 2) {
      map.clear();  // Map leeren
      // Elemente einfügen
      for (int i = 0; i < inserts; i++) {
        map.put(i, 42);
      }
      // Messe 10x 10.000.000 Lookups und berechne den Durchschnittswert
      int repeat = 10;
      double time = 0;
      for (int i = 0; i < repeat; i++) {
        long start = System.currentTimeMillis();
        for (int j = 0; j < 10000000; j++) {
          map.get(0); // Lookup
        }
        time += System.currentTimeMillis() - start;
      }
      // Gebe die Zeit aus
      System.out.println("(" + inserts + "," + time/repeat + ")");
    }
  }
  
  public static void main(String[] args) {
    HashMap<Integer, Integer> hashtable = new HashMap<Integer, Integer>();
    TreeMap<Integer, Integer> tree = new TreeMap<Integer, Integer>();
    benchmark(tree);
  }
}